/*
 * Projet Mon Suivi Conso
 * Récupérarions des consommations electriques
 * Envoi sur serveur externe
 * Documentation sur blog
 */

#include <TFT.h>  // Arduino LCD library
#include <SPI.h>  // Arduino SPI library
#include <WiFi.h> // Arduino WIFI library
#include <WiFiClient.h> // Arduino WIFIClient library
// #include <SD.h> // Arduino Card SD Library

#include <EmonLib.h> // Include Emon Library

/* Initialisations */
/* Wifi */
char ssid[] = "SFR_9F38";
char pass[] = "sinskarchrotherher9i";
int keyIndex = 0;

int status = WL_IDLE_STATUS;

int compte = 0;
double tIrms1 = 0;
double tIrms2 = 0;
double tIrms3 = 0;
double tIrms4 = 0;
double tIrms5 = 0;
double tIrms6 = 0;

double total1 = 0;
double total2 = 0;
double total3 = 0;
double total4 = 0;
double total5 = 0;
double total6 = 0;

char server[] = "www.fissiaux.org";    // numeric IP for my Ftp (no DNS)

static const byte BUFFER_SIZE = 128;

static const unsigned long PERIODE_ECRITURE_DONNEES  =  120000 ; // 60000 UL=1'  120000 UL=2' 300000 UL=5'

WiFiClient client; // Initialize the Ethernet client library

// const int chipSelect = 4; // Pin for SD Card on Wifi Shield

/* Tft */
#define CS   3
#define DC   2
#define RESET 1

EnergyMonitor emon1, emon2, emon3, emon4, emon5, emon6;            // Create an instance pour chaque CT
TFT TFTscreen = TFT(CS, DC, RESET);                                // Creation instance pour LCD


void setup ()
{
  Serial.begin(9600);
  emon1.voltage(0, 226.26, 1.7);  // Voltage: input pin, calibration, phase_shift
  emon2.current(1, 29);
  emon3.current(2, 29);
  emon4.current(3, 29);
  emon5.current(4, 29);
  emon6.current(5, 29);
  TFTscreen.begin();
  TFTscreen.background(0, 0, 0);
  TFTscreen.stroke(71, 201, 68);
  TFTscreen.setTextSize(2);
  TFTscreen.text(" CONSOS ELEC ", 5, 0);
  TFTscreen.setTextSize(1);
  TFTscreen.text("Initialisation ... ", 10, 30);
  delay(1000);
  TFTscreen.text("Connexion ... ", 10, 40);
  delay(1000);
  while (status != WL_CONNECTED) {  // attempt to connect to Wifi network:
    Serial.print("Connexion au reseau Wifi: ");
    Serial.println(ssid);
    status = WiFi.begin(ssid, pass);
    delay(3000);     // wait 3 seconds for connection:
  }
  Serial.print("Connecte au wifi : ");
  printWifiStatus();
  efface_ecran();
}

void loop () {
  premiere_mesure();
  donnees();
  compte = compte + 1;
}

void premiere_mesure() {
  int Vrms = emon1.calcVrms(1480); // Calculate Vrms only
  double Irms1 = emon2.calcIrms(1480); // Calculate Irms only (G0)  //ct.calcIrms(number of wavelengths sample)
  double Irms2 = emon3.calcIrms(1480); // Calculate Irms only (G1)
  double Irms3 = emon4.calcIrms(1480); // Calculate Irms only (G2)
  double Irms4 = emon5.calcIrms(1480); // Calculate Irms only (G3)
  double Irms5 = emon6.calcIrms(1480); // Calculate Irms only (G4)
  double Irms6 = Irms1 - (Irms2 + Irms3 + Irms4 + Irms5); // Calculate Irms only (G5)
} 
void donnees() {
  int Vrms, power1, power2, power3, power4, power5, power6;
  char cstr0[6], cstr1[6], cstr2[6], cstr3[6], cstr4[6], cstr5[6], cstr6[6], cstr7[6], cstr8[6], cstr9[6], cstr10[6], cstr11[6], cstr12[6] ;
  String str0, str1, str2, str3, str4, str5, str6, str7, str8, str9, str10, str11, str12;
  static unsigned long derniere_ecriture = 0;


  Vrms = emon1.calcVrms(1480); // Calculate Vrms only
  double Irms1 = emon2.calcIrms(1480); // Calculate Irms only (G0)  //ct.calcIrms(number of wavelengths sample)
  double Irms2 = emon3.calcIrms(1480); // Calculate Irms only (G1)
  double Irms3 = emon4.calcIrms(1480); // Calculate Irms only (G2)
  double Irms4 = emon5.calcIrms(1480); // Calculate Irms only (G3)
  double Irms5 = emon6.calcIrms(1480); // Calculate Irms only (G4)
  double Irms6 = Irms1 - (Irms2 + Irms3 + Irms4 + Irms5); // Calculate Irms only (G5)
  if (Irms6 < 0) {
    Irms6 = 0;
  }
  if (compte == 2) {
    tIrms1 = Irms1;
    tIrms2 = Irms2;
    tIrms3 = Irms3;
    tIrms4 = Irms4;
    tIrms5 = Irms5;
  }
  power1 = Irms1 * Vrms;
  power2 = Irms2 * Vrms;
  power3 = Irms3 * Vrms;
  power4 = Irms4 * Vrms;
  power5 = Irms5 * Vrms;
  power6 = Irms6 * Vrms;
  total1 = total1 + Irms1;
  tIrms1 = total1 / compte;
  total2 = total2 + Irms2;
  tIrms2 = total2 / compte;
  total3 = total3 + Irms3;
  tIrms3 = total3 / compte;
  total4 = total4 + Irms4;
  tIrms4 = total4 / compte;
  total5 = total5 + Irms5;
  tIrms5 = total5 / compte;
  total6 = total6 + Irms6;
  tIrms6 = total6 / compte;
/*
  Serial.print(" Irms1 = ");
  Serial.print(Irms1);
  Serial.print(" Power1 = ");
  Serial.print(power1);
  Serial.print(" Total1 = ");
  Serial.print(total1);
  Serial.print(" tIrms1 = ");
  Serial.print(tIrms1);
  Serial.println("");
  Serial.print(" Irms2 = ");
  Serial.print(Irms2);
  Serial.print(" Power2 = ");
  Serial.print(power2);
  Serial.print(" Total2 = ");
  Serial.print(total2);
  Serial.print(" tIrms2 = ");
  Serial.print(tIrms2);
  Serial.println("");
  Serial.print(" Irms3 = ");
  Serial.print(Irms3);
  Serial.print(" Power3 = ");
  Serial.print(power3);
  Serial.print(" Total3 = ");
  Serial.print(total3);
  Serial.print(" tIrms3 = ");
  Serial.print(tIrms3);
  Serial.println("");
  Serial.print(" Irms4 = ");
  Serial.print(Irms4);
  Serial.print(" Power4 = ");
  Serial.print(power4);
  Serial.print(" Total4 = ");
  Serial.print(total4);
  Serial.print(" tIrms4 = ");
  Serial.print(tIrms4);
  Serial.println("");
  Serial.print(" Irms5 = ");
  Serial.print(Irms5);
  Serial.print(" Power5 = ");
  Serial.print(power5);
  Serial.print(" Total5 = ");
  Serial.print(total5);
  Serial.print(" tIrms5 = ");
  Serial.print(tIrms5);
  Serial.println("");
  Serial.print(" Irms6 = ");
  Serial.print(Irms6);
  Serial.print(" Power6 = ");
  Serial.print(power6);
  Serial.print(" Total6 = ");
  Serial.print(total6);
  Serial.print(" tIrms6 = ");
  Serial.print(tIrms6);
  Serial.println("");
  Serial.print(" Vrms = ");
  Serial.println(Vrms);
  */
  str0 = String(Vrms);
  str0.toCharArray(cstr0, 5);
  str1 = String(Irms1);
  str1.toCharArray(cstr1, 5);
  str2 = String(Irms2);
  str2.toCharArray(cstr2, 5);
  str3 = String(Irms3);
  str3.toCharArray(cstr3, 5);
  str4 = String(Irms4);
  str4.toCharArray(cstr4, 5);
  str5 = String(Irms5);
  str5.toCharArray(cstr5, 5);
  str6 = String(Irms6);
  str6.toCharArray(cstr6, 5);
  str7 = String(power1);
  str7.toCharArray(cstr7, 5);
  str8 = String(power2);
  str8.toCharArray(cstr8, 5);
  str9 = String(power3);
  str9.toCharArray(cstr9, 5);
  str10 = String(power4);
  str10.toCharArray(cstr10, 5);
  str11 = String(power5);
  str11.toCharArray(cstr11, 5);
  str12 = String(power6);
  str12.toCharArray(cstr12, 5);

  if ((millis() - derniere_ecriture) > PERIODE_ECRITURE_DONNEES) {

    /* Envoi des donnees */   // mettre lecture du OK en retour de page Php, sinon ne pas re-initialiser les valeurs
    tIrms1 = tIrms1 * 100;
    tIrms2 = tIrms2 * 100;
    tIrms3 = tIrms3 * 100;
    tIrms4 = tIrms4 * 100;
    tIrms5 = tIrms5 * 100;
    tIrms6 = tIrms6 * 100;
    if (sendData(tIrms1, tIrms2, tIrms3, tIrms4, tIrms5, tIrms6, Vrms)) {  // mettre lecture du OK (retour booleen true) en retour de page Php, sinon ne pas re-initialiser les valeurs
      /* Sauvegarde du temps courant */
      derniere_ecriture = millis();
      compte = 1;
      total1 = 0;
      total2 = 0;
      total3 = 0;
      total4 = 0;
      total5 = 0;
      total6 = 0;
      efface_ecran();
   }   
  }
  TFTscreen.stroke(255, 255, 0); 
  TFTscreen.text(cstr1, 75, 30);
  TFTscreen.text(cstr7, 110, 30);
  TFTscreen.text(cstr2, 75, 40);
  TFTscreen.text(cstr8, 110, 40);
  TFTscreen.text(cstr3, 75, 50);
  TFTscreen.text(cstr9, 110, 50);
  TFTscreen.text(cstr4, 75, 60);
  TFTscreen.text(cstr10, 110, 60);
  TFTscreen.text(cstr5, 75, 70);
  TFTscreen.text(cstr11, 110, 70);
  TFTscreen.text(cstr6, 75, 80);
  TFTscreen.text(cstr12, 110, 80);
  TFTscreen.text(cstr0, 110, 100);
  delay(4000);
  TFTscreen.stroke(0, 0, 0);
  TFTscreen.text(cstr1, 75, 30);
  TFTscreen.text(cstr7, 110, 30);
  TFTscreen.text(cstr2, 75, 40);
  TFTscreen.text(cstr8, 110, 40);
  TFTscreen.text(cstr3, 75, 50);
  TFTscreen.text(cstr9, 110, 50);
  TFTscreen.text(cstr4, 75, 60);
  TFTscreen.text(cstr10, 110, 60);
  TFTscreen.text(cstr5, 75, 70);
  TFTscreen.text(cstr11, 110, 70);
  TFTscreen.text(cstr6, 75, 80);
  TFTscreen.text(cstr12, 110, 80);
  TFTscreen.text(cstr0, 110, 100);
  TFTscreen.stroke(71, 201, 68);
}

//routine envoi de donnes
boolean sendData(int Irms1, int Irms2, int Irms3, int Irms4, int Irms5, int Irms6, int Vrms) {

  char buffer[BUFFER_SIZE];

  Serial.println(F("Connexion au serveur ... "));
  if (!client.connect(server, 80)) {
    Serial.println(F("Echec envoi!"));
    return false;
  }
  // debut envoi
  //  Serial.println(F("Debut envoi"));
  sprintf(buffer, "%d&G1=%d&G2=%d&G3=%d&G4=%d&G5=%d&T0=%d", Irms1, Irms2, Irms3, Irms4, Irms5, Irms6, Vrms);
  Serial.println(buffer);
  client.print(F("GET /consos/sauvdata.php?G0="));
  client.print(buffer);
  client.println(F(" HTTP/1.0"));
  client.println("Host: www.fissiaux.org");
  client.println();
  // fin envoi
  Serial.println(F("Fin envoi ..."));
  delay(100); // Normalement 10 mis a 100 pour eviter les non envois
  client.stop();
  return true;
}

//routine etat wifi
void printWifiStatus() {
  Serial.print("SSID: ");
  Serial.print(WiFi.SSID());
  IPAddress ip = WiFi.localIP();
  Serial.print(", IP Address: ");
  Serial.print(ip);
  long rssi = WiFi.RSSI();
  Serial.print(", signal strength (RSSI):");
  Serial.print(rssi);
  Serial.println(" dBm.");
  TFTscreen.text("Connecte Wifi a ", 10, 30);
  TFTscreen.text(WiFi.SSID(), 110, 30);
  delay(10000);
  efface_ecran;
}

//routine efface Tft
void efface_ecran() {
  TFTscreen.begin();
  TFTscreen.background(0, 0, 0);
  TFTscreen.stroke(71, 201, 68);
  TFTscreen.setTextSize(2);
  TFTscreen.text(" CONSOS ELEC ", 0, 0);
  TFTscreen.setTextSize(1);
  affiche_matrice();
}

//routine efface Tft
void affiche_matrice() {
  TFTscreen.text("General  = ", 10, 30);
  TFTscreen.text("A", 100, 30);
  TFTscreen.text("W", 140, 30);
  TFTscreen.text("Lavages  = ", 10, 40);
  TFTscreen.text("A", 100, 40);
  TFTscreen.text("W", 140, 40);
  TFTscreen.text("Cuisson  = ", 10, 50);
  TFTscreen.text("A", 100, 50);
  TFTscreen.text("W", 140, 50);
  TFTscreen.text("Froid    = ", 10, 60);
  TFTscreen.text("A", 100, 60);
  TFTscreen.text("W", 140, 60);
  TFTscreen.text("Lumieres = ", 10, 70);
  TFTscreen.text("A", 100, 70);
  TFTscreen.text("W", 140, 70);
  TFTscreen.text("Prises   = ", 10, 80);
  TFTscreen.text("A", 100, 80);
  TFTscreen.text("W", 140, 80);
  TFTscreen.text("Tension  = ", 10, 100);
  TFTscreen.text("V", 140, 100);
  TFTscreen.text("Wifi:", 0, 120);
  TFTscreen.text(WiFi.SSID(), 30, 120);
  if (WiFi.SSID() != "") {
    TFTscreen.text("Transmit:OK", 90, 120);
  }
}



/* Notes
 Ajouter LED pour acquisition WIFI (Bicolore ou allumée/éteinte)
 Ajouter LED pour connexion serveur
 Ajouter LED pour envoi DATA
 Ajouter Bouton poussoir pour affichage qu'apres appui sur bouton
 Voir affichage sur ecran externe
 */










